/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.menu.slot;

import com.technicalitiesmc.lib.container.item.ItemContainer;
import com.technicalitiesmc.lib.menu.slot.ColoredSlot;
import com.technicalitiesmc.lib.menu.slot.LockableSlot;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TKSlot
extends Slot
implements LockableSlot,
ColoredSlot {
    private static final Container EMPTY_CONTAINER = new SimpleContainer(0);
    private final ItemContainer inventory;
    private final int slot;
    private final Set<Consumer<TKSlot>> updateCallbacks = new HashSet<Consumer<TKSlot>>();
    private boolean locked = false;
    private int color = 0;

    public TKSlot(int x, int y, ItemContainer inventory, int slot) {
        super(EMPTY_CONTAINER, 0, x, y);
        this.inventory = inventory;
        this.slot = slot;
    }

    public TKSlot lock() {
        this.locked = true;
        return this;
    }

    public TKSlot withColor(int color) {
        this.color = color;
        return this;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    public void onChanged(Consumer<TKSlot> callback) {
        this.updateCallbacks.add(callback);
    }

    public int getIndex() {
        return this.slot;
    }

    public ItemStack m_7993_() {
        return this.inventory.get(this.slot);
    }

    public void m_5852_(ItemStack stack) {
        this.inventory.set(this.slot, stack);
        for (Consumer<TKSlot> consumer : this.updateCallbacks) {
            consumer.accept(this);
        }
    }

    public void m_6654_() {
        super.m_6654_();
        for (Consumer<TKSlot> consumer : this.updateCallbacks) {
            consumer.accept(this);
        }
    }

    public ItemStack m_6201_(int amount) {
        ItemStack item = this.m_7993_();
        ItemStack split = item.m_41620_(amount);
        this.m_5852_(item);
        return split;
    }

    public int m_6641_() {
        return 64;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSameInventory(Slot other) {
        if (!(other instanceof TKSlot)) return false;
        TKSlot s = (TKSlot)other;
        if (s.inventory != this.inventory) return false;
        return true;
    }

    public boolean m_5857_(ItemStack stack) {
        return !this.isLocked() && super.m_5857_(stack);
    }

    public boolean m_8010_(Player player) {
        return !this.isLocked() && super.m_8010_(player);
    }
}

